/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;

public class CapJPanel
extends JPanel
implements ActionListener {
    JTabbedPane myMasterPane;
    SolidRenderPanel myAssociatedSolidRenderPanel;
    SolidObject newSolidObject;
    JTextField capTextField;
    FoldingNet newNet;
    NetDrawArea myAssociatedNetDrawArea;
    ThreeDViewer myThreeDViewer;
    NetSizeTB myNetSizeTB;
    SolidObject previousSolidObject;

    public CapJPanel(JTabbedPane jTabbedPane, SolidRenderPanel solidRenderPanel, NetDrawArea netDrawArea, ThreeDViewer threeDViewer, NetSizeTB netSizeTB) {
        this.myMasterPane = jTabbedPane;
        this.setPreferredSize(new Dimension(150, 150));
        this.setBackground(Color.white);
        this.setLayout(new FlowLayout());
        this.add(new JLabel("Add a cap"));
        this.add(new JLabel("Enter a height"));
        this.add(new JLabel("cap height:  "));
        this.capTextField = new JTextField("1.0", 5);
        this.add(this.capTextField);
        this.add(new JLabel("and then click on"));
        this.add(new JLabel("the face to cap"));
        this.myAssociatedSolidRenderPanel = solidRenderPanel;
        this.myAssociatedNetDrawArea = netDrawArea;
        this.myThreeDViewer = threeDViewer;
        this.myNetSizeTB = netSizeTB;
        JButton jButton = new JButton("unfold");
        jButton.setActionCommand("unfold");
        jButton.addActionListener(this);
        this.add(jButton);
        JButton jButton2 = new JButton("restore");
        jButton2.setActionCommand("restore");
        jButton2.addActionListener(this);
        this.add(jButton2);
        this.newSolidObject = new SolidObject();
        this.previousSolidObject = new SolidObject();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object;
        double d = this.myNetSizeTB.currentNetSize;
        int n = this.myMasterPane.getSelectedIndex();
        System.out.println("inside action performed of CapJPanel .... ");
        System.out.println("the current index is ... ");
        System.out.println(n);
        if (actionEvent.getActionCommand().equals("unfold")) {
            object = this.capTextField.getText();
            double d2 = Double.valueOf((String)object);
            SolidObject solidObject = this.myAssociatedSolidRenderPanel.mySolid;
            this.previousSolidObject = this.myAssociatedSolidRenderPanel.mySolid;
            this.newSolidObject = solidObject.AddCapToSolid(d2, this.myAssociatedSolidRenderPanel.activeFace);
            this.newNet = this.newSolidObject.UnfoldSolid(d);
            this.myAssociatedNetDrawArea.clearAllPaintVectors();
            this.myAssociatedNetDrawArea.updateFoldingNet(this.newNet);
            this.myAssociatedSolidRenderPanel.updateSolid(this.newSolidObject);
            this.myAssociatedSolidRenderPanel.repaint();
            this.myThreeDViewer.updateWireFrame(this.newSolidObject);
        }
        if (actionEvent.getActionCommand().equals("restore")) {
            System.out.println("handling restore button");
            this.newSolidObject = this.previousSolidObject;
            this.newSolidObject.PrintMyPoints();
            object = this.previousSolidObject.ApplyMapToSolid(1.0, "z-axis");
            this.newNet = ((SolidObject)object).UnfoldSolid(d);
            this.myAssociatedNetDrawArea.clearAllPaintVectors();
            this.myAssociatedNetDrawArea.updateFoldingNet(this.newNet);
            this.myAssociatedSolidRenderPanel.updateSolid((SolidObject)object);
            this.myAssociatedSolidRenderPanel.repaint();
            this.myThreeDViewer.updateWireFrame(this.newSolidObject);
        }
    }
}

