/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;

class Line3d {
    Point3d e1;
    Point3d e2;

    Line3d() {
        this.e1 = new Point3d();
        this.e2 = new Point3d();
    }

    Line3d(Point3d point3d, Point3d point3d2) {
        this.e1 = point3d;
        this.e2 = point3d2;
    }

    public void PrintMyLine() {
        System.out.println("printing Line3d object");
        System.out.println("e1 --------------");
        System.out.println(this.e1.x);
        System.out.println(this.e1.y);
        System.out.println(this.e1.z);
        System.out.println("e2 --------------");
        System.out.println(this.e2.x);
        System.out.println(this.e2.y);
        System.out.println(this.e2.z);
    }

    public boolean Line3dEqual(Line3d line3d) {
        if (this.e1.Point3dEqual(line3d.e1) && this.e2.Point3dEqual(line3d.e2)) {
            return true;
        }
        return this.e1.Point3dEqual(line3d.e2) && this.e2.Point3dEqual(line3d.e1);
    }

    public boolean Line3dWeakEqual(Line3d line3d) {
        if (this.e1.Point3dWeakEqual(line3d.e1) && this.e2.Point3dWeakEqual(line3d.e2)) {
            return true;
        }
        return this.e1.Point3dWeakEqual(line3d.e2) && this.e2.Point3dWeakEqual(line3d.e1);
    }

    public boolean Line3dEqualWithinEps(Line3d line3d, double d) {
        return this.e1.Point3dDistance(line3d.e1) < d && this.e2.Point3dDistance(line3d.e2) < d || this.e2.Point3dDistance(line3d.e1) < d && this.e1.Point3dDistance(line3d.e2) < d;
    }

    public boolean Line3dWeakSharesEndpoint(Line3d line3d) {
        return this.e1.Point3dWeakEqual(line3d.e1) || this.e1.Point3dWeakEqual(line3d.e2) || this.e2.Point3dWeakEqual(line3d.e1) || this.e2.Point3dWeakEqual(line3d.e2);
    }

    public boolean FoundWeak3dLineMatchGivenVec(Vector vector) {
        for (int i = 0; i < vector.size(); ++i) {
            if (!this.Line3dWeakEqual((Line3d)vector.elementAt(i))) continue;
            return true;
        }
        return false;
    }

    public LineFGH GetLineFGHFromLine3d() {
        double d = this.e2.x - this.e1.x;
        double d2 = this.e2.y - this.e1.y;
        double d3 = this.e2.z - this.e1.z;
        return new LineFGH(d, d2, d3);
    }

    public LineFGH GetNormalizedFGHFromLine3d() {
        LineFGH lineFGH = this.GetLineFGHFromLine3d();
        double d = Math.sqrt(lineFGH.f * lineFGH.f + lineFGH.g * lineFGH.g + lineFGH.h * lineFGH.h);
        lineFGH.f /= d;
        lineFGH.g /= d;
        lineFGH.h /= d;
        if (Math.abs(lineFGH.f) < JavaGami2.geomEpsilon3) {
            lineFGH.f = 0.0;
        }
        if (Math.abs(lineFGH.g) < JavaGami2.geomEpsilon3) {
            lineFGH.g = 0.0;
        }
        if (Math.abs(lineFGH.h) < JavaGami2.geomEpsilon3) {
            lineFGH.h = 0.0;
        }
        return lineFGH;
    }

    public double FindAngleBetweenLines3d(Line3d line3d) {
        LineFGH lineFGH = this.GetNormalizedFGHFromLine3d();
        LineFGH lineFGH2 = line3d.GetNormalizedFGHFromLine3d();
        double d = Math.acos(lineFGH.f * lineFGH2.f + lineFGH.g * lineFGH2.g + lineFGH.h * lineFGH2.h);
        return d;
    }

    public Line2d FindProjectionOfLine3d() {
        double d = this.e1.x;
        double d2 = this.e2.x;
        double d3 = this.e1.y;
        double d4 = this.e2.y;
        return new Line2d(new Point2d(d, d3), new Point2d(d2, d4));
    }

    public boolean SameLineAs(Line3d line3d) {
        return this.e1.Point3dWeakEqual(line3d.e2) && this.e2.Point3dWeakEqual(line3d.e1) || this.e1.Point3dWeakEqual(line3d.e1) && this.e2.Point3dWeakEqual(line3d.e2);
    }

    public Line3d ReverseEndpointsOfEdge() {
        double d = this.e1.x;
        double d2 = this.e1.y;
        double d3 = this.e1.z;
        double d4 = this.e2.x;
        double d5 = this.e2.y;
        double d6 = this.e2.z;
        return new Line3d(new Point3d(d4, d5, d6), new Point3d(d, d2, d3));
    }

    public boolean HasEndpoint(Point3d point3d) {
        if (this.e1.Point3dWeakEqual(point3d)) {
            return true;
        }
        return this.e2.Point3dWeakEqual(point3d);
    }

    public Point3d FindPointOnLineGivenDistAndEndpt(double d, Point3d point3d) {
        Point3d point3d2 = new Point3d(0.0, 0.0, 0.0);
        Point3d point3d3 = new Point3d(0.0, 0.0, 0.0);
        if (this.e1.Point3dWeakEqual(point3d)) {
            point3d2 = this.e1;
            point3d3 = this.e2;
        } else {
            point3d2 = this.e2;
            point3d3 = this.e1;
        }
        double d2 = point3d3.x - point3d2.x;
        double d3 = point3d3.y - point3d2.y;
        double d4 = point3d3.z - point3d2.z;
        double d5 = point3d2.x + (d2 *= d);
        double d6 = point3d2.y + (d3 *= d);
        double d7 = point3d2.z + (d4 *= d);
        return new Point3d(d5, d6, d7);
    }
}

