/*
 * Decompiled with CFR 0.152.
 */
class Plane {
    double a;
    double b;
    double c;
    double d;

    Plane(double d, double d2, double d3, double d4) {
        this.a = d;
        this.b = d2;
        this.c = d3;
        this.d = d4;
    }

    Plane(Point3d point3d, Point3d point3d2, Point3d point3d3) {
        double d = point3d2.x - point3d.x;
        double d2 = point3d2.y - point3d.y;
        double d3 = point3d2.z - point3d.z;
        double d4 = point3d3.x - point3d.x;
        double d5 = point3d3.y - point3d.y;
        double d6 = point3d3.z - point3d.z;
        this.a = d2 * d6 - d3 * d5;
        this.b = d3 * d4 - d * d6;
        this.c = d * d5 - d2 * d4;
        this.d = -1.0 * (point3d2.x * this.a + point3d2.y * this.b + point3d2.z * this.c);
        double d7 = this.a < 0.0 || this.a == 0.0 && this.b < 0.0 || this.a == 0.0 && this.b == 0.0 && this.c < 0.0 ? -1.0 : 1.0;
        this.a *= d7;
        this.b *= d7;
        this.c *= d7;
        this.d *= d7;
    }

    public boolean PlaneEquals(Plane plane) {
        if (Math.abs(this.a - plane.a) < JavaGami2.geomEpsilon3) {
            if (Math.abs(this.b - plane.b) < JavaGami2.geomEpsilon3) {
                if (Math.abs(this.c - plane.c) < JavaGami2.geomEpsilon3) {
                    return Math.abs(this.d - plane.d) < JavaGami2.geomEpsilon3;
                }
                return false;
            }
            return false;
        }
        return false;
    }

    public Plane NormalizePlane() {
        if (Math.abs(this.a) < JavaGami2.geomEpsilon3) {
            this.a = 0.0;
        }
        if (Math.abs(this.b) < JavaGami2.geomEpsilon3) {
            this.b = 0.0;
        }
        if (Math.abs(this.c) < JavaGami2.geomEpsilon3) {
            this.c = 0.0;
        }
        if (Math.abs(this.d) < JavaGami2.geomEpsilon3) {
            this.d = 0.0;
        }
        double d = Math.sqrt(this.a * this.a + this.b * this.b + this.c * this.c);
        double d2 = this.a < 0.0 || this.a == 0.0 && this.b < 0.0 || this.a == 0.0 && this.b == 0.0 && this.c < 0.0 ? -1.0 : 1.0;
        if (d < JavaGami2.geomEpsilon3) {
            return new Plane(0.0, 0.0, 0.0, 0.0);
        }
        double d3 = this.a / d * d2;
        double d4 = this.b / d * d2;
        double d5 = this.c / d * d2;
        double d6 = this.d / d * d2;
        return new Plane(d3, d4, d5, d6);
    }

    public double DistanceFromPointToPlaneABCD(Point3d point3d) throws DreadfulProblemException {
        double d = this.a * this.a + this.b * this.b + this.c * this.c;
        if (d < JavaGami2.geomEpsilon3) {
            DreadfulProblemException dreadfulProblemException = new DreadfulProblemException();
            throw dreadfulProblemException;
        }
        double d2 = Math.pow(point3d.x * this.a + point3d.y * this.b + point3d.z * this.c + this.d, 2.0);
        return Math.sqrt(d2 / d);
    }

    public boolean IsPointInPlaneABCD(Point3d point3d) {
        double d = 0.0;
        try {
            d = this.DistanceFromPointToPlaneABCD(point3d);
        }
        catch (DreadfulProblemException dreadfulProblemException) {
            System.out.println("the denom of plane dist is close to 0");
        }
        return d < JavaGami2.geomEpsilon3;
    }

    public Point3d FindNormalizedPointPerpendicularToPlane() {
        return new Point3d(this.a, this.b, this.c);
    }

    public Point3d FindIntersectionPointOfThreePlanes(Plane plane, Plane plane2) throws DreadfulProblemException {
        Plane plane3 = this;
        double d = plane.b * plane2.c - plane2.b * plane.c;
        double d2 = plane.a * plane2.b - plane2.a * plane.b;
        double d3 = plane.a * plane2.c - plane2.a * plane.c;
        double d4 = plane3.a * d + plane3.c * d2 + -(plane3.b * d3);
        if (Math.abs(d4) < JavaGami2.geomEpsilon1) {
            DreadfulProblemException dreadfulProblemException = new DreadfulProblemException("planes are almost parallel");
            throw dreadfulProblemException;
        }
        double d5 = plane.d * plane2.c - (plane2.d - plane.c);
        double d6 = plane.d * plane2.b - plane2.d * plane.b;
        double d7 = plane.a * plane2.d - plane2.a * plane.d;
        double d8 = 1.0 / d4;
        double d9 = d8 * (plane3.b * d5 + -(plane3.d * d) + -(plane3.c * d6));
        double d10 = d8 * (plane3.d * d3 + -(plane3.a * d5) + -(plane3.c * d7));
        double d11 = d8 * (plane3.b * d7 + -(plane3.a * d6) + -(plane3.d * d2));
        return new Point3d(d9, d10, d11);
    }

    public double AngleBetweenNormalToPlaneAndLine3d(Line3d line3d) {
        LineFGH lineFGH = line3d.GetNormalizedFGHFromLine3d();
        Plane plane = this.NormalizePlane();
        double d = Math.acos(plane.a * lineFGH.f + plane.b * lineFGH.g + plane.c * lineFGH.h);
        return d;
    }

    public Point3d IntersectionBetweenLineAndPlane(Line3d line3d) {
        LineFGH lineFGH = line3d.GetNormalizedFGHFromLine3d();
        double d = (line3d.e1.x * this.a + line3d.e1.y * this.b + line3d.e1.z * this.c + this.d) / (this.a * lineFGH.f + this.b * lineFGH.g + this.c * lineFGH.h);
        double d2 = d * -1.0;
        double d3 = line3d.e1.x + d2 * lineFGH.f;
        double d4 = line3d.e1.y + d2 * lineFGH.g;
        double d5 = line3d.e1.z + d2 * lineFGH.h;
        Point3d point3d = new Point3d(d3, d4, d5);
        return point3d;
    }
}

