/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;

class Point3d {
    double x;
    double y;
    double z;
    double SRValue;

    Point3d() {
    }

    Point3d(double d, double d2, double d3) {
        this.x = d;
        this.y = d2;
        this.z = d3;
    }

    public void PrintMyPoint() {
        System.out.println("printing Point3d ------");
        System.out.println(this.x);
        System.out.println(this.y);
        System.out.println(this.z);
    }

    public void SetMySRValue(double d) {
        this.SRValue = d;
    }

    public Point2d Project3dTo2d() {
        return new Point2d(this.x, this.y);
    }

    public Point3d Point3dAdd(Point3d point3d) {
        double d = this.x + point3d.x;
        double d2 = this.y + point3d.y;
        double d3 = this.z + point3d.z;
        return new Point3d(d, d2, d3);
    }

    public Point3d Point3dSubtract(Point3d point3d) {
        double d = this.x - point3d.x;
        double d2 = this.y - point3d.y;
        double d3 = this.z - point3d.z;
        return new Point3d(d, d2, d3);
    }

    public boolean Point3dEqual(Point3d point3d) {
        return this.x == point3d.x && this.y == point3d.y && this.z == point3d.z;
    }

    public boolean Point3dWeakEqual(Point3d point3d) {
        double d = 1.0E-4;
        return Math.abs(this.x - point3d.x) < d && Math.abs(this.y - point3d.y) < d && Math.abs(this.z - point3d.z) < d;
    }

    public double Point3dDistance(Point3d point3d) {
        return Math.sqrt(Math.pow(this.x - point3d.x, 2.0) + Math.pow(this.y - point3d.y, 2.0) + Math.pow(this.z - point3d.z, 2.0));
    }

    public Plane FindPlaneABCDFromThreePoints(Point3d point3d, Point3d point3d2) {
        double d = point3d.x - this.x;
        double d2 = point3d.y - this.y;
        double d3 = point3d.z - this.z;
        double d4 = point3d2.x - this.x;
        double d5 = point3d2.y - this.y;
        double d6 = point3d2.z - this.z;
        double d7 = d2 * d6 - d3 * d5;
        double d8 = d3 * d4 - d * d6;
        double d9 = d * d5 - d2 * d4;
        double d10 = -(point3d.x * d7 + point3d.y * d8 + point3d.z * d9);
        double d11 = d7 == 0.0 || d7 == 0.0 && d8 < 0.0 || d7 == 0.0 && d8 == 0.0 && d9 < 0.0 ? -1.0 : 1.0;
        return new Plane(d7 * d11, d8 * d11, d9 * d11, d10 * d11);
    }

    public Plane FindNormalizedPlaneABCDFromThreePoints(Point3d point3d, Point3d point3d2) {
        Plane plane = this.FindPlaneABCDFromThreePoints(point3d, point3d2);
        Plane plane2 = plane.NormalizePlane();
        return plane2;
    }

    public Point3d NormalizeVector() {
        double d = Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
        double d2 = this.x / d;
        double d3 = this.y / d;
        double d4 = this.z / d;
        return new Point3d(d2, d3, d4);
    }

    public Point3d Point3dCrossProduct(Point3d point3d) {
        double d = this.y * point3d.z - this.z * point3d.y;
        double d2 = this.z * point3d.x - this.x * point3d.z;
        double d3 = this.x * point3d.y - this.y * point3d.x;
        return new Point3d(d, d2, d3);
    }

    public double Point3dDotProduct(Point3d point3d) {
        return this.x * point3d.x + this.y * point3d.y + this.z * point3d.z;
    }

    public Point3d Point3dScale(double d) {
        double d2 = this.x * d;
        double d3 = this.y * d;
        double d4 = this.z * d;
        return new Point3d(d2, d3, d4);
    }

    public Line3d MakeRayFromOriginGivenPointVector() {
        return new Line3d(new Point3d(0.0, 0.0, 0.0), this);
    }

    public int VertexIndexPosition(Vector vector) {
        boolean bl = false;
        int n = 0;
        while (!bl && n < vector.size()) {
            Point3d point3d = (Point3d)vector.elementAt(n);
            if (this.Point3dWeakEqual(point3d)) {
                bl = true;
                continue;
            }
            ++n;
        }
        return n;
    }
}

