/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Polygon;
import java.util.Vector;

public class Polygon2d
extends Polygon {
    Point2d[] myPoints;

    Polygon2d(Point2d[] point2dArray) {
        this.myPoints = point2dArray;
    }

    Polygon2d() {
    }

    Polygon2d(int[] nArray, int[] nArray2, int n) {
        super(nArray, nArray2, n);
    }

    public void PrintMyPoints() {
        int n = this.myPoints.length;
        System.out.println("printing points of polygon 2d");
        for (int i = 0; i < n; ++i) {
            System.out.println("-------------");
            System.out.println(i);
            System.out.println("-------------");
            System.out.println(this.myPoints[i].x);
            System.out.println(this.myPoints[i].y);
        }
    }

    public Polygon2d ConvertToScreenCoords(double d, double d2, double d3, double d4, double d5) {
        Point2d[] point2dArray = new Point2d[this.myPoints.length];
        double d6 = d5 / (d2 - d);
        double d7 = d5 / (d4 - d3);
        double d8 = d6 > d7 ? d7 : d6;
        for (int i = 0; i < this.myPoints.length; ++i) {
            Point2d point2d = this.myPoints[i];
            point2d.x = (point2d.x - d) * d8;
            point2d.y = (point2d.y - d3) * d8;
            point2dArray[i] = new Point2d(point2d.x, point2d.y);
        }
        return new Polygon2d(point2dArray);
    }

    public int NumberShared2dVertices(Polygon2d polygon2d) {
        int n = this.myPoints.length;
        int n2 = polygon2d.myPoints.length;
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            if (!this.FoundMatching2dPoint(polygon2d, this.myPoints[i])) continue;
            ++n3;
        }
        return n3;
    }

    private boolean FoundMatching2dPoint(Polygon2d polygon2d, Point2d point2d) {
        for (int i = 0; i < polygon2d.myPoints.length; ++i) {
            if (!point2d.Point2dWeakEqual(polygon2d.myPoints[i])) continue;
            return true;
        }
        return false;
    }

    public Vector FindEdgesForPoly() {
        int n = this.myPoints.length;
        Vector<Line2d> vector = new Vector<Line2d>();
        for (int i = 0; i < n - 1; ++i) {
            vector.addElement(new Line2d(this.myPoints[i], this.myPoints[i + 1]));
        }
        vector.addElement(new Line2d(this.myPoints[n - 1], this.myPoints[0]));
        return vector;
    }

    public Line2d FindEdgeGivenPosition(int n) {
        Vector vector = this.FindEdgesForPoly();
        return (Line2d)vector.elementAt(n);
    }

    public boolean Polygon2dEqual(Polygon2d polygon2d) {
        Vector vector = this.FindEdgesForPoly();
        Vector vector2 = polygon2d.FindEdgesForPoly();
        if (vector.size() == vector2.size()) {
            for (int i = 0; i < vector.size(); ++i) {
                if (this.HasPolygonEdgeMatch((Line2d)vector.elementAt(i), vector2)) {
                    continue;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean HasPolygonEdgeMatch(Line2d line2d, Vector vector) {
        for (int i = 0; i < vector.size(); ++i) {
            if (!line2d.Line2dEqual((Line2d)vector.elementAt(i))) continue;
            return true;
        }
        return false;
    }

    public boolean PointInsidePolygon2d(Point2d point2d) {
        if (this.myPoints.length == 3) {
            return this.PointInsideTriangle2d(point2d);
        }
        return this.PointInsideLargePolygon2d(point2d);
    }

    public boolean PointInsideTriangle2d(Point2d point2d) {
        Line2d line2d = new Line2d(this.myPoints[0], this.myPoints[1]);
        Line2d line2d2 = new Line2d(this.myPoints[1], this.myPoints[2]);
        Line2d line2d3 = new Line2d(this.myPoints[2], this.myPoints[0]);
        Line2d line2d4 = new Line2d(point2d, new Point2d(50000.0, point2d.y + 3.0));
        boolean bl = line2d4.IntersectingNonOverlapLines2d(line2d);
        boolean bl2 = line2d4.IntersectingNonOverlapLines2d(line2d2);
        boolean bl3 = line2d4.IntersectingNonOverlapLines2d(line2d3);
        return bl3 && !bl && !bl2 || bl && !bl2 && !bl3 || bl2 && !bl && !bl2;
    }

    public boolean PointInsideLargePolygon2d(Point2d point2d) {
        int n;
        Vector vector = new Vector();
        int n2 = 0;
        Line2d line2d = new Line2d(point2d, new Point2d(50000.0, point2d.y + 3.0));
        vector = this.FindEdgesForPoly();
        for (n = 0; n < vector.size(); ++n) {
            if (!line2d.IntersectingNonOverlapLines2d((Line2d)vector.elementAt(n))) continue;
            ++n2;
        }
        for (n = 0; n < this.myPoints.length; ++n) {
            if (!line2d.IntersectingNonOverlapLines2d(new Line2d(this.myPoints[n], this.myPoints[n]))) continue;
            --n2;
        }
        return n2 == 1;
    }

    public double MinOverXs() {
        double d = this.myPoints[0].x;
        for (int i = 0; i < this.myPoints.length; ++i) {
            if (!(this.myPoints[i].x < d)) continue;
            d = this.myPoints[i].x;
        }
        return d;
    }

    public double MaxOverXs() {
        double d = this.myPoints[0].x;
        for (int i = 0; i < this.myPoints.length; ++i) {
            if (!(this.myPoints[i].x > d)) continue;
            d = this.myPoints[i].x;
        }
        return d;
    }

    public double MinOverYs() {
        double d = this.myPoints[0].y;
        for (int i = 0; i < this.myPoints.length; ++i) {
            if (!(this.myPoints[i].y < d)) continue;
            d = this.myPoints[i].y;
        }
        return d;
    }

    public double MaxOverYs() {
        double d = this.myPoints[0].y;
        for (int i = 0; i < this.myPoints.length; ++i) {
            if (!(this.myPoints[i].y > d)) continue;
            d = this.myPoints[i].y;
        }
        return d;
    }

    public Polygon2d TranslateToCenterRotateTranslateBack(double d) {
        Point2d point2d = this.CenterOfPolygon2d();
        Polygon2d polygon2d = new Map2dTranslate(-point2d.x, -point2d.y).ApplyMapToPolygon2dObject(this);
        Polygon2d polygon2d2 = new Map2dRotate(d).ApplyMapToPolygon2dObject(polygon2d);
        Polygon2d polygon2d3 = new Map2dTranslate(point2d.x, point2d.y).ApplyMapToPolygon2dObject(polygon2d2);
        return polygon2d3;
    }

    public boolean NonOverlappingPolys(Polygon2d polygon2d) {
        double d = this.MinOverXs();
        double d2 = polygon2d.MinOverXs();
        double d3 = this.MaxOverXs();
        double d4 = polygon2d.MaxOverXs();
        double d5 = this.MinOverYs();
        double d6 = polygon2d.MinOverYs();
        double d7 = this.MaxOverYs();
        double d8 = polygon2d.MaxOverYs();
        boolean bl = d3 <= d2 || d >= d4 || d7 <= d6 || d5 >= d8 || this.NonOverlappingPolys1(polygon2d);
        return bl;
    }

    public boolean HasAVertexCloseTo(Point2d point2d) {
        boolean bl = false;
        for (int i = 0; i < this.myPoints.length; ++i) {
            Point2d point2d2 = this.myPoints[i];
            if (!(point2d2.Point2dDistance(point2d) < JavaGami2.geomEpsilon1)) continue;
            bl = true;
        }
        return bl;
    }

    public boolean NonOverlappingPolys1(Polygon2d polygon2d) {
        int n = this.NumberShared2dVertices(polygon2d);
        boolean bl = this.NonOverlappingPolys2(polygon2d) ? n == 2 || (n == 0 || n == 1) && this.NonOverlappingPolys3(polygon2d) : false;
        return bl;
    }

    public boolean NonOverlappingPolys2a(Polygon2d polygon2d) {
        int n = 0;
        boolean bl = true;
        while (n < this.myPoints.length && bl) {
            Point2d point2d = this.myPoints[n];
            boolean bl2 = polygon2d.PointInsidePolygon2d(point2d);
            if (!bl2) {
                ++n;
                continue;
            }
            if (bl2 && polygon2d.HasAVertexCloseTo(point2d)) {
                ++n;
                continue;
            }
            bl = false;
        }
        return bl;
    }

    public boolean NonOverlappingPolys2b(Polygon2d polygon2d) {
        int n = 0;
        boolean bl = true;
        while (n < polygon2d.myPoints.length && bl) {
            Point2d point2d = polygon2d.myPoints[n];
            boolean bl2 = this.PointInsidePolygon2d(point2d);
            if (!bl2) {
                ++n;
                continue;
            }
            if (bl2 && this.HasAVertexCloseTo(point2d)) {
                ++n;
                continue;
            }
            bl = false;
        }
        return bl;
    }

    public boolean NonOverlappingPolys2(Polygon2d polygon2d) {
        return this.NonOverlappingPolys2a(polygon2d) && this.NonOverlappingPolys2b(polygon2d);
    }

    public boolean NonOverlappingPolys3(Polygon2d polygon2d) {
        Vector vector = this.FindEdgesForPoly();
        Vector vector2 = polygon2d.FindEdgesForPoly();
        boolean bl = true;
        for (int i = 0; i < vector.size() && bl; ++i) {
            Line2d line2d = (Line2d)vector.elementAt(i);
            for (int j = 0; j < vector2.size(); ++j) {
                Line2d line2d2 = (Line2d)vector2.elementAt(j);
                if (line2d.Line2dWeakEqual(line2d2) || line2d.Line2dWeakSharesEndpoint(line2d2) || !line2d.IntersectingNonOverlapLines2d(line2d2)) continue;
                bl = false;
            }
        }
        return bl;
    }

    public Point2d CenterOfPolygon2d() {
        double d = 0.0;
        double d2 = 0.0;
        int n = this.myPoints.length;
        for (int i = 0; i < n; ++i) {
            d += this.myPoints[i].x;
            d2 += this.myPoints[i].y;
        }
        double d3 = d / (double)n;
        double d4 = d2 / (double)n;
        return new Point2d(d3, d4);
    }

    public Polygon2d TranslateToOriginAndPlaceVertexOnX() {
        Point2d point2d = this.CenterOfPolygon2d();
        Map2dTranslate map2dTranslate = new Map2dTranslate(-point2d.x, -point2d.y);
        Polygon2d polygon2d = map2dTranslate.ApplyMapToPolygon2dObject(this);
        Point2d point2d2 = polygon2d.myPoints[0];
        Line2d line2d = new Line2d(new Point2d(0.0, 0.0), point2d2);
        Line2d line2d2 = new Line2d(new Point2d(0.0, 0.0), new Point2d(1.0, 0.0));
        double d = line2d2.AngleBetweenLines2d(line2d);
        int n = point2d2.FindMyQuadrant();
        Map2dRotate map2dRotate = n == 1 || n == 2 ? new Map2dRotate(-d) : new Map2dRotate(d);
        Polygon2d polygon2d2 = map2dRotate.ApplyMapToPolygon2dObject(polygon2d);
        return polygon2d2;
    }
}

