/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;

public class Polygon3d {
    Point3d[] myPoints;

    Polygon3d(Polygon3d polygon3d) {
        this.myPoints = polygon3d.myPoints;
    }

    Polygon3d(Point3d[] point3dArray) {
        this.myPoints = point3dArray;
    }

    Polygon3d() {
        this.myPoints = new Point3d[3];
    }

    public void PrintMyPoints() {
        int n = this.myPoints.length;
        System.out.println("printing points of polygon 3d");
        for (int i = 0; i < n; ++i) {
            System.out.println("-------------");
            System.out.println(i);
            System.out.println("-------------");
            System.out.println(this.myPoints[i].x);
            System.out.println(this.myPoints[i].y);
            System.out.println(this.myPoints[i].z);
        }
    }

    public Vector FindEdgesForPoly3d() {
        int n = this.myPoints.length;
        Vector<Line3d> vector = new Vector<Line3d>();
        for (int i = 0; i < n - 1; ++i) {
            vector.addElement(new Line3d(this.myPoints[i], this.myPoints[i + 1]));
        }
        vector.addElement(new Line3d(this.myPoints[n - 1], this.myPoints[0]));
        return vector;
    }

    public int NumberShared3dVertices(Polygon3d polygon3d) {
        int n = this.myPoints.length;
        int n2 = polygon3d.myPoints.length;
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            if (!this.foundMatching3dPoint(polygon3d, this.myPoints[i])) continue;
            ++n3;
        }
        return n3;
    }

    private boolean foundMatching3dPoint(Polygon3d polygon3d, Point3d point3d) {
        for (int i = 0; i < polygon3d.myPoints.length; ++i) {
            if (!point3d.Point3dWeakEqual(polygon3d.myPoints[i])) continue;
            return true;
        }
        return false;
    }

    public boolean Polygon3dWeakEqual(Polygon3d polygon3d) {
        Vector vector = this.FindEdgesForPoly3d();
        Vector vector2 = polygon3d.FindEdgesForPoly3d();
        if (vector.size() == vector2.size()) {
            for (int i = 0; i < vector.size(); ++i) {
                if (((Line3d)vector.elementAt(i)).FoundWeak3dLineMatchGivenVec(vector2)) {
                    continue;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    public Plane FindPlaneABCDFromPolygon() {
        Point3d point3d = this.myPoints[0];
        Point3d point3d2 = this.myPoints[1];
        Point3d point3d3 = this.myPoints[2];
        return point3d.FindPlaneABCDFromThreePoints(point3d2, point3d3);
    }

    public Plane FindNormalizedPlaneABCDFromPolygon() {
        Point3d point3d = this.myPoints[0];
        Point3d point3d2 = this.myPoints[1];
        Point3d point3d3 = this.myPoints[2];
        return point3d.FindNormalizedPlaneABCDFromThreePoints(point3d2, point3d3);
    }

    public boolean IsPointInPlaneOfPolygon(Point3d point3d) {
        Plane plane = this.FindNormalizedPlaneABCDFromPolygon();
        return plane.IsPointInPlaneABCD(point3d);
    }

    public Point3d FindNormalToPlaneOfPolygon3d() {
        Vector vector = this.FindEdgesForPoly3d();
        Line3d line3d = (Line3d)vector.elementAt(0);
        Line3d line3d2 = (Line3d)vector.elementAt(1);
        Line3d line3d3 = new Line3d(line3d.e2, line3d.e1);
        Point3d point3d = line3d3.e2.Point3dSubtract(line3d3.e1);
        Point3d point3d2 = line3d2.e2.Point3dSubtract(line3d2.e1);
        Point3d point3d3 = point3d2.Point3dCrossProduct(point3d);
        return point3d3;
    }

    public double FindAngleBetweenPolygon3dAndZAxis() {
        Point3d point3d = this.FindNormalToPlaneOfPolygon3d();
        Line3d line3d = point3d.MakeRayFromOriginGivenPointVector();
        Line3d line3d2 = new Line3d(new Point3d(0.0, 0.0, 0.0), new Point3d(0.0, 0.0, 1.0));
        double d = line3d.FindAngleBetweenLines3d(line3d2);
        return d;
    }

    public Polygon2d ProjectPolygon3dOntoXYPlane() {
        Point2d[] point2dArray = new Point2d[this.myPoints.length];
        for (int i = 0; i < this.myPoints.length; ++i) {
            double d = this.myPoints[i].x;
            double d2 = this.myPoints[i].y;
            point2dArray[i] = new Point2d(d, d2);
        }
        return new Polygon2d(point2dArray);
    }

    public Point3d CenterOfPolygon3d() {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        int n = this.myPoints.length;
        for (int i = 0; i < n; ++i) {
            d += this.myPoints[i].x;
            d2 += this.myPoints[i].y;
            d3 += this.myPoints[i].z;
        }
        double d4 = d / (double)n;
        double d5 = d2 / (double)n;
        double d6 = d3 / (double)n;
        return new Point3d(d4, d5, d6);
    }

    public Polygon2d PlacePolygon3dOnXYPlane() {
        Point3d point3d = this.CenterOfPolygon3d();
        Map3dTranslate map3dTranslate = new Map3dTranslate(-point3d.x, -point3d.y, -point3d.z);
        Polygon3d polygon3d = map3dTranslate.ApplyMapToPolygon3dObject(this);
        Point3d point3d2 = polygon3d.FindNormalToPlaneOfPolygon3d();
        Line3d line3d = point3d2.MakeRayFromOriginGivenPointVector();
        Line2d line2d = line3d.FindProjectionOfLine3d();
        Line2d line2d2 = new Line2d(new Point2d(0.0, 0.0), new Point2d(0.0, 1.0));
        double d = polygon3d.FindAngleBetweenPolygon3dAndZAxis();
        double d2 = line2d.AngleBetweenLines2d(line2d2);
        Polygon3d polygon3d2 = new Map3dRotateZ(-d2).ApplyMapToPolygon3dObject(polygon3d);
        Point3d point3d3 = polygon3d2.FindNormalToPlaneOfPolygon3d();
        Line3d line3d2 = point3d3.MakeRayFromOriginGivenPointVector();
        Polygon3d polygon3d3 = line3d2.e2.y < 0.0 ? new Map3dRotateZ(3.14159265).ApplyMapToPolygon3dObject(polygon3d2) : polygon3d2;
        Polygon3d polygon3d4 = new Map3dRotateX(d).ApplyMapToPolygon3dObject(polygon3d3);
        Point3d point3d4 = polygon3d4.FindNormalToPlaneOfPolygon3d();
        Line3d line3d3 = point3d4.MakeRayFromOriginGivenPointVector();
        Polygon3d polygon3d5 = line3d3.e2.z < 0.0 ? new Map3dRotateX(3.14159265).ApplyMapToPolygon3dObject(polygon3d4) : polygon3d4;
        Polygon2d polygon2d = polygon3d5.ProjectPolygon3dOntoXYPlane();
        return polygon2d;
    }

    public int FindEdgePosition(Line3d line3d) {
        Vector vector = this.FindEdgesForPoly3d();
        int n = 0;
        boolean bl = false;
        while (!bl && n < vector.size()) {
            if (line3d.SameLineAs((Line3d)vector.elementAt(n))) {
                bl = true;
                continue;
            }
            ++n;
        }
        return n;
    }
}

