/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.swing.RepaintManager;

public class PrintUtilities
implements Printable {
    private Component componentToBePrinted;

    public static void printComponent(Component component) {
        new PrintUtilities(component).print();
    }

    public PrintUtilities(Component component) {
        this.componentToBePrinted = component;
    }

    public void print() {
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        printerJob.setPrintable(this);
        if (printerJob.printDialog()) {
            try {
                printerJob.print();
            }
            catch (PrinterException printerException) {
                System.out.println("Error printing: " + printerException);
            }
        }
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) {
        if (n > 0) {
            return 1;
        }
        Dimension dimension = this.componentToBePrinted.getSize();
        BufferedImage bufferedImage = new BufferedImage(dimension.width, dimension.height, 1);
        Graphics graphics2 = bufferedImage.getGraphics();
        this.componentToBePrinted.paint(graphics2);
        return 0;
    }

    public static void disableDoubleBuffering(Component component) {
        RepaintManager repaintManager = RepaintManager.currentManager(component);
        repaintManager.setDoubleBufferingEnabled(false);
    }

    public static void enableDoubleBuffering(Component component) {
        RepaintManager repaintManager = RepaintManager.currentManager(component);
        repaintManager.setDoubleBufferingEnabled(true);
    }
}

