/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileInputStream;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class SliceJPanel
extends JPanel
implements ActionListener {
    JTabbedPane myMasterPane;
    SolidRenderPanel myAssociatedSolidRenderPanel;
    SolidObject newSolidObject;
    FoldingNet newNet;
    NetDrawArea myAssociatedNetDrawArea;
    ThreeDViewer myThreeDViewer;
    JButton showSlice1Button;
    JButton showSlice2Button;
    JButton sliceUnfoldButton;
    JButton undoPointsButton;
    NetSizeTB myNetSizeTB;

    public SliceJPanel(JTabbedPane jTabbedPane, SolidRenderPanel solidRenderPanel, NetDrawArea netDrawArea, ThreeDViewer threeDViewer, NetSizeTB netSizeTB) {
        this.myMasterPane = jTabbedPane;
        this.setPreferredSize(new Dimension(150, 150));
        this.setBackground(Color.white);
        this.setLayout(new FlowLayout());
        this.add(new JLabel("slice the shape"));
        this.add(new JLabel("click three vertexes to slice"));
        this.myAssociatedSolidRenderPanel = solidRenderPanel;
        this.myAssociatedNetDrawArea = netDrawArea;
        this.myThreeDViewer = threeDViewer;
        this.myNetSizeTB = netSizeTB;
        this.sliceUnfoldButton = new JButton("unfold");
        this.sliceUnfoldButton.setActionCommand("unfold");
        this.sliceUnfoldButton.addActionListener(this);
        this.add(this.sliceUnfoldButton);
        this.undoPointsButton = new JButton("undo");
        this.undoPointsButton.setActionCommand("undo");
        this.undoPointsButton.addActionListener(this);
        this.add(this.undoPointsButton);
        this.showSlice1Button = new JButton("slice 1");
        this.showSlice1Button.setActionCommand("show1");
        this.showSlice1Button.addActionListener(this);
        this.add(this.showSlice1Button);
        this.showSlice2Button = new JButton("slice 2");
        this.showSlice2Button.setActionCommand("show2");
        this.showSlice2Button.addActionListener(this);
        this.add(this.showSlice2Button);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        double d = this.myNetSizeTB.currentNetSize;
        Model3D model3D = new Model3D();
        Model3D model3D2 = new Model3D();
        float f = 1.0f;
        Vector<Point3d> vector = new Vector<Point3d>();
        Vector<SolidFace> vector2 = new Vector<SolidFace>();
        int n = this.myMasterPane.getSelectedIndex();
        System.out.println("inside action performed of TruncJPanel .... ");
        System.out.println("the current index is ... ");
        System.out.println(n);
        if (actionEvent.getActionCommand().equals("unfold")) {
            if (this.myAssociatedSolidRenderPanel.selectedPoints.size() >= 3) {
                Point3d point3d = (Point3d)this.myAssociatedSolidRenderPanel.selectedPoints.elementAt(0);
                Point3d point3d2 = (Point3d)this.myAssociatedSolidRenderPanel.selectedPoints.elementAt(1);
                Point3d point3d3 = (Point3d)this.myAssociatedSolidRenderPanel.selectedPoints.elementAt(2);
                SolidObjects solidObjects = this.myAssociatedSolidRenderPanel.mySolid.SplitSolidIntoTwoParts(new Plane(point3d, point3d2, point3d3));
                System.out.println("generated two slices **************");
            }
            this.myAssociatedSolidRenderPanel.clearSelectedPoints();
        } else if (actionEvent.getActionCommand().equals("undo")) {
            this.myAssociatedSolidRenderPanel.clearSelectedPoints();
            this.myAssociatedSolidRenderPanel.clearClickedPoints();
            this.myAssociatedSolidRenderPanel.clearPanelAndRedrawSolid();
            System.out.println("undo button hit");
        } else if (actionEvent.getActionCommand().equals("show1") || actionEvent.getActionCommand().equals("show2")) {
            SolidObject solidObject;
            int n2;
            try {
                float f2;
                float f3;
                FileInputStream fileInputStream = actionEvent.getActionCommand().equals("show1") ? new FileInputStream("SliceOne") : new FileInputStream("SliceTwo");
                model3D2 = model3D = new Model3D(fileInputStream);
                model3D.findBB();
                model3D.compress();
                float f4 = model3D.xmax - model3D.xmin;
                float f5 = model3D.ymax - model3D.ymin;
                float f6 = model3D.zmax - model3D.zmin;
                if (f5 > f4) {
                    f4 = f5;
                }
                if (f6 > f4) {
                    f4 = f6;
                }
                float f7 = 0.7f * ((f3 = (float)this.size().width / f4) < (f2 = (float)this.size().height / f4) ? f3 : f2) * f;
                this.myThreeDViewer.setMyXFac(f7);
                this.myThreeDViewer.setModel(model3D2);
                this.myThreeDViewer.repaint();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (vector.size() != 0) {
                vector.removeAllElements();
            }
            for (n2 = 0; n2 < model3D.mySolidVerts.size(); ++n2) {
                Point3d point3d = new Point3d(0.0, 0.0, 0.0);
                point3d = (Point3d)model3D.mySolidVerts.elementAt(n2);
                vector.addElement(point3d);
            }
            if (vector2.size() != 0) {
                vector2.removeAllElements();
            }
            for (n2 = 0; n2 < model3D.mySolidFaces.size(); ++n2) {
                SolidFace solidFace = new SolidFace();
                solidFace = (SolidFace)model3D.mySolidFaces.elementAt(n2);
                vector2.addElement(solidFace);
            }
            this.newSolidObject = solidObject = new SolidObject(vector2, vector);
            this.newNet = this.newSolidObject.UnfoldSolid(d);
            this.myAssociatedNetDrawArea.updateFoldingNet(this.newNet);
            this.myAssociatedSolidRenderPanel.updateSolid(this.newSolidObject);
            this.myAssociatedSolidRenderPanel.repaint();
            this.myThreeDViewer.updateWireFrame(this.newSolidObject);
        }
    }
}

