/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Polygon;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.JTabbedPane;

public class SolidRenderPanel
extends Canvas {
    SolidObject mySolid;
    SolidObject myPreviousSolid;
    boolean mySolidInitialized;
    boolean myPreviousSolidInitialized;
    NetDrawArea myAssociatedNetDrawArea;
    Point2d offset;
    Polygon activePolygon;
    SolidFace activeFace;
    String workMode;
    Vector selectedPoints;
    int solidDrawMode;
    SolidObject newSolidObject;
    JTabbedPane myAssociatedTabbedPane;
    int numericMode;
    Map3dOrthogonal orthmap = new Map3dOrthogonal(0.5235987755982988, 1.3962634015954636, 0.0);
    Vector clickedPoints;
    NetSizeTB myNetSizeTB;
    ThreeDViewer myThreeDViewer;

    SolidRenderPanel(NetDrawArea netDrawArea, ThreeDViewer threeDViewer) {
        this.offset = new Point2d(100.0, 100.0);
        this.setSize(200, 200);
        this.selectedPoints = new Vector();
        this.clickedPoints = new Vector();
        this.myPreviousSolidInitialized = false;
        this.mySolidInitialized = false;
        this.addMouseListener(new MyMouseListener());
        this.myAssociatedNetDrawArea = netDrawArea;
        this.myThreeDViewer = threeDViewer;
    }

    public void clearPanel() {
        this.solidDrawMode = 0;
        this.repaint();
        this.solidDrawMode = 1;
    }

    public void clearPanelAndRedrawSolid() {
        this.clearPanel();
        this.repaint();
    }

    public void clearClickedPoints() {
        this.clickedPoints.removeAllElements();
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        Toolkit.getDefaultToolkit().sync();
        Point2d point2d = new Point2d(0.0, 0.0);
        Point2d point2d2 = new Point2d(0.0, 0.0);
        if (this.solidDrawMode == 0) {
            graphics.setColor(Color.white);
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        } else {
            this.setBackground(Color.white);
            graphics.setColor(Color.black);
            if (this.mySolid != null) {
                System.out.println("before draw of solid object");
                this.mySolid.draw(graphics, this.offset);
                System.out.println("after draw of solid object");
            }
            if (this.clickedPoints.size() > 0) {
                graphics.setColor(Color.red);
                for (int i = 0; i < this.clickedPoints.size(); ++i) {
                    point2d = (Point2d)this.clickedPoints.elementAt(i);
                    point2d2 = point2d.ScreenTransform2D(this.offset);
                    graphics.fillOval((int)point2d2.x, (int)point2d2.y, 5, 5);
                }
            }
        }
    }

    public void SetMyAssociatedTabbedPane(JTabbedPane jTabbedPane) {
        this.myAssociatedTabbedPane = jTabbedPane;
    }

    public void SetWorkMode(String string) {
        this.workMode = string;
    }

    public void clearSelectedPoints() {
        this.selectedPoints.removeAllElements();
    }

    public void clearSolidWindow() {
        this.solidDrawMode = 0;
        this.repaint();
        this.clearClickedPoints();
        this.solidDrawMode = 1;
    }

    public void updateSolid(SolidObject solidObject) {
        this.mySolidInitialized = true;
        this.clearSolidWindow();
        this.updatePreviousSolid(this.mySolid);
        this.mySolid = solidObject;
        this.mySolid.PrintMyPoints();
        this.repaint();
    }

    public void restorePreviousSolid() {
        double d = 300.0;
        this.mySolid = this.myPreviousSolid;
        SolidObject solidObject = this.myPreviousSolid.ApplyMapToSolid(1.0, "z-axis");
        FoldingNet foldingNet = solidObject.UnfoldSolid(d);
        this.myAssociatedNetDrawArea.clearAllPaintVectors();
        this.myAssociatedNetDrawArea.updateFoldingNet(foldingNet);
        this.updateSolid(solidObject);
        this.repaint();
        this.myThreeDViewer.updateWireFrame(solidObject);
    }

    public void updatePreviousSolid(SolidObject solidObject) {
        this.myPreviousSolidInitialized = true;
        this.myPreviousSolid = solidObject;
    }

    public void rotateAndUpdateSolid(String string) {
        double d = 5.0;
        d = d * Math.PI * 2.0 / 360.0;
        this.newSolidObject = this.mySolid.RotateSolid(d, string);
        this.newSolidObject.transform(this.orthmap);
        this.updateSolid(this.newSolidObject);
    }

    private Polygon findSolidCanvasPolygon(int n, int n2) {
        int n3;
        Polygon polygon = null;
        for (n3 = 0; n3 < this.mySolid.visiblePolysInSolidCanvas.size(); ++n3) {
            ((SolidFace)this.mySolid.solidFacesOfVisiblePolys.elementAt(n3)).setOutlineColor(Color.black);
        }
        this.repaint();
        for (n3 = 0; n3 < this.mySolid.visiblePolysInSolidCanvas.size() && !(polygon = (Polygon)this.mySolid.visiblePolysInSolidCanvas.elementAt(n3)).inside(n, n2); ++n3) {
        }
        if (n3 < this.mySolid.visiblePolysInSolidCanvas.size()) {
            this.activeFace = (SolidFace)this.mySolid.solidFacesOfVisiblePolys.elementAt(n3);
            ((SolidFace)this.mySolid.solidFacesOfVisiblePolys.elementAt(n3)).setOutlineColor(Color.red);
            this.repaint();
            return polygon;
        }
        return null;
    }

    public int findIndexPointClicked(int n, int n2) {
        Point2d point2d = new Point2d(100.0, 100.0);
        double d = 30.0;
        Point2d point2d2 = new Point2d(((double)n - point2d.x) / d, ((double)n2 - point2d.y) / d);
        int n3 = 0;
        this.solidDrawMode = 0;
        this.repaint();
        this.solidDrawMode = 1;
        this.repaint();
        for (int i = 0; i < this.mySolid.screenVertList.size(); ++i) {
            Point2d point2d3 = (Point2d)this.mySolid.screenVertList.elementAt(i);
            if (!point2d3.Point2dInMyNeighborhood(point2d2)) continue;
            n3 = i;
            this.clickedPoints.addElement(point2d3);
            this.repaint();
            break;
        }
        return n3;
    }

    class MyMouseListener
    extends MouseAdapter {
        MyMouseListener() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            int n = 0;
            System.out.println("solid render panel got a click");
            System.out.println(mouseEvent.getX());
            System.out.println(mouseEvent.getY());
            System.out.println("here's the index of the active Pane");
            System.out.println(SolidRenderPanel.this.myAssociatedTabbedPane.getModel().getSelectedIndex());
            SolidRenderPanel.this.numericMode = SolidRenderPanel.this.myAssociatedTabbedPane.getModel().getSelectedIndex();
            System.out.println("here's the numericMode variable");
            System.out.println(SolidRenderPanel.this.numericMode);
            if (SolidRenderPanel.this.numericMode == 2) {
                SolidRenderPanel.this.selectedPoints.removeAllElements();
                SolidRenderPanel.this.clickedPoints.removeAllElements();
                System.out.println("removed elements from clickedPoints");
                n = SolidRenderPanel.this.findIndexPointClicked(mouseEvent.getX(), mouseEvent.getY());
                SolidRenderPanel.this.selectedPoints.addElement((Point3d)SolidRenderPanel.this.mySolid.vertList.elementAt(n));
            }
            if (SolidRenderPanel.this.numericMode == 3) {
                n = SolidRenderPanel.this.findIndexPointClicked(mouseEvent.getX(), mouseEvent.getY());
                SolidRenderPanel.this.selectedPoints.addElement((Point3d)SolidRenderPanel.this.mySolid.vertList.elementAt(n));
            }
            if (SolidRenderPanel.this.numericMode == 1) {
                SolidRenderPanel.this.activePolygon = SolidRenderPanel.this.findSolidCanvasPolygon(mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }
}

