/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class StretchJPanel
extends JPanel
implements ActionListener {
    SolidRenderPanel myAssociatedSolidRenderPanel;
    SolidObject newSolidObject;
    JTextField textField;
    ButtonGroup group;
    JRadioButton xAxisButton;
    JRadioButton yAxisButton;
    JRadioButton zAxisButton;
    JButton stretchUnfoldButton;
    JPanel radioPanel;
    String stretchState;
    FoldingNet newNet;
    NetDrawArea myAssociatedNetDrawArea;
    ThreeDViewer myThreeDViewer;
    NetSizeTB myNetSizeTB;

    public StretchJPanel(SolidRenderPanel solidRenderPanel, NetDrawArea netDrawArea, ThreeDViewer threeDViewer, NetSizeTB netSizeTB) {
        this.setLayout(new BorderLayout());
        this.myAssociatedSolidRenderPanel = solidRenderPanel;
        this.myAssociatedNetDrawArea = netDrawArea;
        this.myThreeDViewer = threeDViewer;
        this.setBackground(Color.white);
        this.setPreferredSize(new Dimension(150, 150));
        this.stretchUnfoldButton = new JButton("Unfold");
        this.stretchUnfoldButton.setActionCommand("unfold");
        this.stretchUnfoldButton.addActionListener(this);
        this.xAxisButton = new JRadioButton("x-axis");
        this.yAxisButton = new JRadioButton("y-axis");
        this.zAxisButton = new JRadioButton("z-axis");
        this.xAxisButton.setActionCommand("x-axis");
        this.yAxisButton.setActionCommand("y-axis");
        this.zAxisButton.setActionCommand("z-axis");
        this.group = new ButtonGroup();
        this.group.add(this.xAxisButton);
        this.group.add(this.yAxisButton);
        this.group.add(this.zAxisButton);
        RadioListener radioListener = new RadioListener();
        this.xAxisButton.addActionListener(radioListener);
        this.yAxisButton.addActionListener(radioListener);
        this.zAxisButton.addActionListener(radioListener);
        this.radioPanel = new JPanel();
        this.radioPanel.add(this.xAxisButton);
        this.radioPanel.add(this.yAxisButton);
        this.radioPanel.add(this.zAxisButton);
        this.add((Component)this.radioPanel, "Center");
        this.add((Component)this.stretchUnfoldButton, "South");
        this.textField = new JTextField(5);
        this.textField.setActionCommand("textfield");
        this.textField.addActionListener(this);
        this.myNetSizeTB = netSizeTB;
        this.add((Component)this.textField, "North");
    }

    public void actionPerformed(ActionEvent actionEvent) {
        double d = this.myNetSizeTB.currentNetSize;
        if (actionEvent.getActionCommand().equals("unfold")) {
            System.out.println("got an unfold click");
            String string = this.textField.getText();
            double d2 = Double.valueOf(string);
            this.newSolidObject = this.myAssociatedSolidRenderPanel.mySolid.ApplyMapToSolid(d2, this.stretchState);
            this.newNet = this.newSolidObject.UnfoldSolid(d);
            this.myAssociatedNetDrawArea.clearAllPaintVectors();
            this.myAssociatedNetDrawArea.updateFoldingNet(this.newNet);
            this.myAssociatedSolidRenderPanel.updateSolid(this.newSolidObject);
            this.myAssociatedSolidRenderPanel.repaint();
            this.myThreeDViewer.updateWireFrame(this.newSolidObject);
        }
    }

    class RadioListener
    implements ActionListener {
        RadioListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            StretchJPanel.this.stretchState = actionEvent.getActionCommand();
            System.out.println("setting state:  ");
            System.out.println(StretchJPanel.this.stretchState);
        }
    }
}

