/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Canvas;
import java.awt.Event;
import java.awt.Graphics;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;

class ThreeDViewer
extends Canvas {
    int prevx;
    int prevy;
    Matrix3D amat = new Matrix3D();
    Matrix3D tmat = new Matrix3D();
    boolean painted = true;
    Model3D md;
    String message = null;
    float xfac;

    ThreeDViewer() {
        this.amat.yrot(20.0);
        this.amat.xrot(20.0);
    }

    public void setModel(Model3D model3D) {
        this.md = model3D;
    }

    public void setMyXFac(float f) {
        this.xfac = f;
    }

    public void updateWireFrame(SolidObject solidObject) {
        Object object;
        Object object2;
        Closeable closeable;
        try {
            closeable = new FileOutputStream("newSolidData");
            object2 = new PrintStream((OutputStream)closeable);
            for (int i = 0; i < solidObject.vertList.size(); ++i) {
                object = (Point3d)solidObject.vertList.elementAt(i);
                if (Math.abs(((Point3d)object).x) < 5.0E-4) {
                    ((Point3d)object).x = 0.0;
                }
                if (Math.abs(((Point3d)object).y) < 5.0E-4) {
                    ((Point3d)object).y = 0.0;
                }
                if (Math.abs(((Point3d)object).z) < 5.0E-4) {
                    ((Point3d)object).z = 0.0;
                }
                ((PrintStream)object2).println("v " + ((Point3d)object).x + " " + ((Point3d)object).y + " " + ((Point3d)object).z + "\n");
            }
            for (int i = 0; i < solidObject.myFaces.size(); ++i) {
                SolidFace solidFace = (SolidFace)solidObject.myFaces.elementAt(i);
                ((PrintStream)object2).print("f ");
                for (int j = 0; j < solidFace.myPoints.length; ++j) {
                    Point3d point3d = solidFace.myPoints[j];
                    int n = point3d.VertexIndexPosition(solidObject.vertList) + 1;
                    ((PrintStream)object2).print(n);
                    ((PrintStream)object2).print(" ");
                }
                ((PrintStream)object2).print("\n");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            float f;
            float f2;
            closeable = new FileInputStream("newSolidData");
            object = object2 = new Model3D((InputStream)closeable);
            ((Model3D)object2).findBB();
            ((Model3D)object2).compress();
            float f3 = ((Model3D)object2).xmax - ((Model3D)object2).xmin;
            float f4 = ((Model3D)object2).ymax - ((Model3D)object2).ymin;
            float f5 = ((Model3D)object2).zmax - ((Model3D)object2).zmin;
            float f6 = 1.0f;
            if (f4 > f3) {
                f3 = f4;
            }
            if (f5 > f3) {
                f3 = f5;
            }
            float f7 = 0.7f * ((f2 = (float)this.size().width / f3) < (f = (float)this.size().height / f3) ? f2 : f) * f6;
            this.setMyXFac(f7);
            this.setModel((Model3D)object);
            this.repaint();
        }
        catch (Exception exception) {
            this.md = null;
            System.out.println("the model md is null!!!");
            this.message = exception.toString();
        }
    }

    public boolean mouseDown(Event event, int n, int n2) {
        this.prevx = n;
        this.prevy = n2;
        return true;
    }

    public boolean mouseDrag(Event event, int n, int n2) {
        this.tmat.unit();
        float f = (float)(this.prevy - n2) * 360.0f / (float)this.size().width;
        float f2 = (float)(n - this.prevx) * 360.0f / (float)this.size().height;
        this.tmat.xrot(f);
        this.tmat.yrot(f2);
        this.amat.mult(this.tmat);
        if (this.painted) {
            this.painted = false;
            this.repaint();
        }
        this.prevx = n;
        this.prevy = n2;
        return true;
    }

    public void paint(Graphics graphics) {
        if (this.md == null) {
            // empty if block
        }
        if (this.md != null) {
            this.md.mat.unit();
            this.md.mat.translate(-(this.md.xmin + this.md.xmax) / 2.0f, -(this.md.ymin + this.md.ymax) / 2.0f, -(this.md.zmin + this.md.zmax) / 2.0f);
            this.md.mat.mult(this.amat);
            this.md.mat.scale(this.xfac, -this.xfac, 16.0f * this.xfac / (float)this.size().width);
            this.md.mat.translate(this.size().width / 2, this.size().height / 2, 8.0f);
            this.md.transformed = false;
            this.md.paint(graphics);
            this.setPainted();
        } else if (this.message != null) {
            graphics.drawString("Error in model:", 3, 20);
            graphics.drawString(this.message, 10, 40);
        }
    }

    private synchronized void setPainted() {
        this.painted = true;
        this.notifyAll();
    }
}

